Type DOCINFO
   cbSize As Integer
   DocName As Long
   Output As Long
End Type

Global Const LF_FACESIZE = 32

Type LOGFONT
    lfHeight As Integer
    lfWidth As Integer
    lfEscapement As Integer
    lfOrientation As Integer
    lfWeight As Integer
    lfItalic As String * 1
    lfUnderline As String * 1
    lfStrikeOut As String * 1
    lfCharSet As String * 1
    lfOutPrecision As String * 1
    lfClipPrecision As String * 1
    lfQuality As String * 1
    lfPitchAndFamily As String * 1
    lfFaceName As String * LF_FACESIZE
End Type

Global Const OUT_DEFAULT_PRECIS = 0
Global Const OUT_STRING_PRECIS = 1
Global Const OUT_CHARACTER_PRECIS = 2
Global Const OUT_STROKE_PRECIS = 3

Global Const CLIP_DEFAULT_PRECIS = 0
Global Const CLIP_CHARACTER_PRECIS = 1
Global Const CLIP_STROKE_PRECIS = 2

Global Const DEFAULT_QUALITY = 0
Global Const DRAFT_QUALITY = 1
Global Const PROOF_QUALITY = 2

Global Const DEFAULT_PITCH = 0
Global Const FIXED_PITCH = 1
Global Const VARIABLE_PITCH = 2

Global Const ANSI_CHARSET = 0
Global Const SYMBOL_CHARSET = 2
Global Const SHIFTJIS_CHARSET = 128
Global Const OEM_CHARSET = 255

'  Font Families
'
Global Const FF_DONTCARE = 0    '  Don't care or don't know.
Global Const FF_ROMAN = 16  '  Variable stroke width, serifed.

'  Times Roman, Century Schoolbook, etc.
Global Const FF_SWISS = 32  '  Variable stroke width, sans-serifed.

'  Helvetica, Swiss, etc.
Global Const FF_MODERN = 48 '  Constant stroke width, serifed or sans-serifed.

'  Pica, Elite, Courier, etc.
Global Const FF_SCRIPT = 64 '  Cursive, etc.
Global Const FF_DECORATIVE = 80 '  Old English, etc.

'  Font Weights
Global Const FW_DONTCARE = 0
Global Const FW_THIN = 100
Global Const FW_EXTRALIGHT = 200
Global Const FW_LIGHT = 300
Global Const FW_NORMAL = 400
Global Const FW_MEDIUM = 500
Global Const FW_SEMIBOLD = 600
Global Const FW_BOLD = 700
Global Const FW_EXTRABOLD = 800
Global Const FW_HEAVY = 900

Global Const FW_ULTRALIGHT = FW_EXTRALIGHT
Global Const FW_REGULAR = FW_NORMAL
Global Const FW_DEMIBOLD = FW_SEMIBOLD
Global Const FW_ULTRABOLD = FW_EXTRABOLD
Global Const FW_BLACK = FW_HEAVY

Global Const GMEM_MOVEABLE = &H2
Global Const GMEM_ZEROINIT = &H40
Global Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)

Global Const PD_RETURNDC = &H100&
Global Const PD_PRINTSETUP = &H40&

Global Const LOGPIXELSX = 88
Global Const LOGPIXELSY = 90

Global hTextFont As Integer, hDataFont As Integer, hCompanyFont As Integer
Global Font As LOGFONT
Global hPen As Integer

Declare Function StartDoc Lib "GDI" (ByVal hDC As Integer, lpdi As DOCINFO) As Integer
Declare Function EndPage Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function EndDocAPI Lib "GDI" Alias "EndDoc" (ByVal hDC As Integer) As Integer
Declare Function StartPage Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function TextOut Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal lpString As String, ByVal nCount As Integer) As Integer
Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Sub hmemcpy Lib "Kernel" (lpDest As Any, lpSource As Any, ByVal dwBytes As Long)
Declare Function TextOut Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal lpString As String, ByVal nCount As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function CreateFontIndirect Lib "GDI" (lpLogFont As LOGFONT) As Integer
Declare Sub DeleteObject Lib "GDI" (ByVal Object%)
Declare Function MoveTo Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer) As Long
Declare Function LineTo Lib "GDI" (ByVal hDC As Integer, ByVal x As Integer, ByVal y As Integer) As Integer
Declare Function CreatePen Lib "GDI" (ByVal nPenStyle As Integer, ByVal nWidth As Integer, ByVal crColor As Long) As Integer
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer

Sub CreateObjects ()
        Font.lfHeight = 35
        Font.lfWidth = 0
        Font.lfEscapement = 0
        Font.lfOrientation = 0
        Font.lfWeight = FW_NORMAL
        Font.lfItalic = Chr$(0)
        Font.lfUnderline = Chr$(0)
        Font.lfStrikeOut = Chr$(0)
        Font.lfCharSet = Chr$(ANSI_CHARSET)
        Font.lfOutPrecision = Chr$(0)
        Font.lfClipPrecision = Chr$(0)
        Font.lfQuality = Chr$(PROOF_QUALITY)
        Font.lfPitchAndFamily = Chr$(DEFAULT_PITCH)
        Font.lfFaceName = Chr$(0)
  
        hTextFont = CreateFontIndirect(Font)

        Font.lfHeight = 70
        Font.lfWidth = 0
        Font.lfEscapement = 0
        Font.lfOrientation = 0
        Font.lfWeight = FW_SEMIBOLD
        Font.lfItalic = Chr$(0)
        Font.lfUnderline = Chr$(0)
        Font.lfStrikeOut = Chr$(0)
        Font.lfCharSet = Chr$(0)
        Font.lfOutPrecision = Chr$(0)
        Font.lfClipPrecision = Chr$(0)
        Font.lfQuality = Chr$(PROOF_QUALITY)
        Font.lfPitchAndFamily = Chr$(DEFAULT_PITCH)
        Font.lfFaceName = "Arial"

        hDataFont = CreateFontIndirect(Font)

        Font.lfHeight = 28
        Font.lfWidth = 0
        Font.lfEscapement = 0
        Font.lfOrientation = 0
        Font.lfWeight = FW_SEMIBOLD
        Font.lfItalic = Chr$(0)
        Font.lfUnderline = Chr$(0)
        Font.lfStrikeOut = Chr$(0)
        Font.lfCharSet = Chr$(ANSI_CHARSET)
        Font.lfOutPrecision = Chr$(0)
        Font.lfClipPrecision = Chr$(0)
        Font.lfQuality = Chr$(PROOF_QUALITY)
        Font.lfPitchAndFamily = Chr$(DEFAULT_PITCH)
        Font.lfFaceName = Chr$(0)
  
        hCompanyFont = CreateFontIndirect(Font)

        hPen = CreatePen(0, 3, &HFFFFFF00)
End Sub

Sub DeleteObjects ()
        DeleteObject hTextFont
        DeleteObject hDataFont
        DeleteObject hCompanyFont
        DeleteObject hPen
End Sub

Sub LineToScale (ByVal hDC As Integer, x As Integer, y As Integer, theScaleMode As Integer)
    Dim xPos As Integer, yPos As Integer, VertRes As Integer, HorzRes As Integer

    VertRes = GetDeviceCaps(hDC, LOGPIXELSY)
    HorzRes = GetDeviceCaps(hDC, LOGPIXELSX)

    Select Case theScaleMode
        Case 1 ' Twip
            xPos = (x / 1440) * HorzRes
            yPos = (y / 1440) * VertRes
        Case 2: ' Point
            xPos = (x / 72) * HorzRes
            yPos = (y / 72) * VertRes
        Case 4: ' Character
            xPos = (x / 12) * HorzRes
            yPos = (y / 6) * VertRes
        Case 5: ' Inch
            xPos = x * HorzRes
            yPos = y * VertRes
        Case 6: ' Millimeter
            xPos = (x * .03937) * HorzRes
            yPos = (y * .03937) * VertRes
        Case 7: ' Centimeter
            xPos = (x * .3937) * HorzRes
            yPos = (y * .3937) * VertRes
        Case Else
            xPos = x
            yPos = y
    End Select

    Ok = LineTo(hDC, xPos, yPos)
End Sub

Sub MoveToScale (ByVal hDC As Integer, x As Integer, y As Integer, theScaleMode As Integer)
    Dim xPos As Integer, yPos As Integer, VertRes As Integer, HorzRes As Integer

    VertRes = GetDeviceCaps(hDC, LOGPIXELSY)
    HorzRes = GetDeviceCaps(hDC, LOGPIXELSX)

    Select Case theScaleMode
        Case 1 ' Twip
            xPos = (x / 1440) * HorzRes
            yPos = (y / 1440) * VertRes
        Case 2: ' Point
            xPos = (x / 72) * HorzRes
            yPos = (y / 72) * VertRes
        Case 4: ' Character
            xPos = (x / 12) * HorzRes
            yPos = (y / 6) * VertRes
        Case 5: ' Inch
            xPos = x * HorzRes
            yPos = y * VertRes
        Case 6: ' Millimeter
            xPos = (x * .03937) * HorzRes
            yPos = (y * .03937) * VertRes
        Case 7: ' Centimeter
            xPos = (x * .3937) * HorzRes
            yPos = (y * .3937) * VertRes
        Case Else
            xPos = x
            yPos = y
    End Select

    Ok = MoveTo(hDC, xPos, yPos)
End Sub

Sub PrintText (ByVal hDC As Integer, ByVal OutStr As String, x As Single, y As Single, hFont As Integer, theScaleMode As Integer)
    Dim xPos As Integer, yPos As Integer, VertRes As Integer, HorzRes As Integer

    VertRes = GetDeviceCaps(hDC, LOGPIXELSY)
    HorzRes = GetDeviceCaps(hDC, LOGPIXELSX)

    Select Case theScaleMode
        Case 1 ' Twip
            xPos = (x / 1440) * HorzRes
            yPos = (y / 1440) * VertRes
        Case 2: ' Point
            xPos = (x / 72) * HorzRes
            yPos = (y / 72) * VertRes
        Case 4: ' Character
            xPos = (x / 12) * HorzRes
            yPos = (y / 6) * VertRes
        Case 5: ' Inch
            xPos = x * HorzRes
            yPos = y * VertRes
        Case 6: ' Millimeter
            xPos = (x * .03937) * HorzRes
            yPos = (y * .03937) * VertRes
        Case 7: ' Centimeter
            xPos = (x * .3937) * HorzRes
            yPos = (y * .3937) * VertRes
        Case Else
            xPos = x
            yPos = y
    End Select

    Ok = SelectObject(hDC, hFont)
    Ok = TextOut(hDC, xPos, yPos, OutStr, Len(OutStr))
End Sub

